

<?php $__env->startSection('content'); ?>
<section class="section">
    <div class="section-header">
        <h3 class="page__heading"><em>Editar Producto</em></h3>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">
            <form action="<?php echo e(route('mercancia.update', $producto)); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <!-- Nombre -->
                <div class="form-group">
                    <label for="nombre">Nombre del producto:</label>
                    <input type="text" name="nombre" class="form-control" value="<?php echo e($producto->nombre); ?>" required>
                </div>

                <!-- Códigos -->
                <div class="form-group">
                    <label for="codigo1">Código 1:</label>
                    <input type="text" name="codigo1" class="form-control" value="<?php echo e($producto->codigo1); ?>" required>
                </div>

                <div class="form-group">
                    <label for="codigo2">Código 2:</label>
                    <input type="text" name="codigo2" class="form-control" value="<?php echo e($producto->codigo2); ?>">
                </div>

                <!-- Descripción -->
                <div class="form-group">
                    <label for="descripcion">Descripción:</label>
                    <textarea name="descripcion" class="form-control" rows="3" required><?php echo e($producto->descripcion); ?></textarea>
                </div>

                <!-- Precios -->
                <div class="form-group">
                    <label for="precio_unidad_facturado">Precio Unidad Facturado (PUF):</label>
                    <input type="number" name="precio_unidad_facturado" step="0.01" class="form-control" value="<?php echo e($producto->precio_unidad_facturado); ?>" required>
                </div>
                <div class="form-group">
                    <label for="precio_docena_facturado">Precio Docena Facturado (PDF):</label>
                    <input type="number" name="precio_docena_facturado" step="0.01" class="form-control" value="<?php echo e($producto->precio_docena_facturado); ?>">
                </div>
                <div class="form-group">
                    <label for="precio_paquete_facturado">Precio Paquete Facturado (PPF):</label>
                    <input type="number" name="precio_paquete_facturado" step="0.01" class="form-control" value="<?php echo e($producto->precio_paquete_facturado); ?>">
                </div>
                <div class="form-group">
                    <label for="precio_paquete_normal">Precio Paquete Normal (PPN):</label>
                    <input type="number" name="precio_paquete_normal" step="0.01" class="form-control" value="<?php echo e($producto->precio_paquete_normal); ?>">
                </div>
                <div class="form-group">
                    <label for="precio_docena_normal">Precio Docena Normal (PDN):</label>
                    <input type="number" name="precio_docena_normal" step="0.01" class="form-control" value="<?php echo e($producto->precio_docena_normal); ?>">
                </div>
                <div class="form-group">
                    <label for="precio_docena_caja">Precio Docena Caja (PDC):</label>
                    <input type="number" name="precio_docena_caja" step="0.01" class="form-control" value="<?php echo e($producto->precio_docena_caja); ?>">
                </div>
                <div class="form-group">
                    <label for="posicion">Posición en el Depósito:</label>
                    <input type="text" name="posicion" class="form-control" value="<?php echo e(old('posicion', $producto->posicion ?? '')); ?>">
                </div>
                <div class="form-group">
                    <label>¿Este producto es válido para su venta en cuarta, media docena y docena?</label>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="docena" id="docena_si" value="1" <?php echo e($producto->docena ? 'checked' : ''); ?> required>
                        <label class="form-check-label" for="docena_si">Sí</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="docena" id="docena_no" value="0" <?php echo e(!$producto->docena ? 'checked' : ''); ?> required>
                        <label class="form-check-label" for="docena_no">No</label>
                    </div>
                </div>
                
                <!-- Incremento y Descuento -->
                <div class="form-group">
                    <label for="incremento">Incremento (%):</label>
                    <input type="number" name="incremento" step="0.01" class="form-control" value="<?php echo e($producto->incremento ?? 0); ?>">
                </div>
                <div class="form-group">
                    <label for="descuento">Descuento (%):</label>
                    <input type="number" name="descuento" step="0.01" class="form-control" value="<?php echo e($producto->descuento ?? 0); ?>">
                </div>

                <!-- Marca -->
                <div class="form-group">
                    <label for="marca">Marca:</label>
                    <input type="text" name="marca" class="form-control" value="<?php echo e($producto->marca); ?>" required>
                </div>

                <!-- Foto -->
                <div class="form-group">
                    <label for="foto">Foto:</label>
                    <input type="file" name="foto" class="form-control-file">
                    <?php if($producto->foto): ?>
                        <img src="<?php echo e(asset($producto->foto)); ?>" alt="Foto actual" class="img-thumbnail mt-2" style="max-width: 150px;">
                    <?php endif; ?>
                </div>

                <!-- Ubicación -->
                <div class="form-group">
                    <label for="ubicacion">Ubicación:</label>
                    <select name="ubicacion_id" class="form-control select2" required>
                        <?php $__currentLoopData = $ubicaciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ubicacion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($ubicacion->id); ?>" <?php echo e($producto->ubicacion_id == $ubicacion->id ? 'selected' : ''); ?>>
                                <?php echo e($ubicacion->nombre); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Cantidad -->
                <div class="form-group">
                    <label for="cantidad">Cantidad:</label>
                    <input type="number" name="cantidad" class="form-control" value="<?php echo e($producto->cantidad); ?>" required>
                </div>

                <!-- Botón de Actualizar -->
                <button type="submit" class="btn btn-primary">Actualizar Producto</button>
            </form>
        </div>
    </div>
</section>

<!-- Scripts -->
<script>
    $(document).ready(function() {
        $('.select2').select2();
    });
</script>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0/css/select2.min.css" rel="stylesheet" />
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0/js/select2.min.js"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\jugueteria\resources\views/mercancia/edit.blade.php ENDPATH**/ ?>