

<?php $__env->startSection('content'); ?>
<section class="section">
    <div class="section-header d-flex justify-content-between align-items-center">
        <h3 class="page__heading">📦 Traspasos de Productos</h3>
        <a href="<?php echo e(route('traspasos.showFormEnviarProducto')); ?>" class="btn btn-primary shadow">➕ Enviar Producto</a>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <!-- Filtros -->
    <div class="card mb-4 shadow-sm">
        <div class="card-body">
            <form action="<?php echo e(route('traspasos.index')); ?>" method="get" class="row align-items-end">
                <div class="col-md-3">
                    <label for="search">🔍 Buscar producto:</label>
                    <input type="text" name="search" class="form-control" placeholder="Nombre del producto" value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-3">
                    <label for="ubicacion_origen_id">📍 Sucursal Origen:</label>
                    <select name="ubicacion_origen_id" class="form-control">
                        <option value="">Todas</option>
                        <?php $__currentLoopData = $ubicaciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ubicacion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($ubicacion->id); ?>" <?php echo e(request('ubicacion_origen_id') == $ubicacion->id ? 'selected' : ''); ?>>
                                <?php echo e($ubicacion->nombre); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="ubicacion_destino_id">📍 Sucursal Destino:</label>
                    <select name="ubicacion_destino_id" class="form-control">
                        <option value="">Todas</option>
                        <?php $__currentLoopData = $ubicaciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ubicacion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($ubicacion->id); ?>" <?php echo e(request('ubicacion_destino_id') == $ubicacion->id ? 'selected' : ''); ?>>
                                <?php echo e($ubicacion->nombre); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-primary btn-block">🔎 Filtrar</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Tabla de Traspasos -->
    <div class="card shadow-sm">
        <div class="card-body">
            <h4 class="mb-4 text-primary">📄 Registro de Traspasos</h4>
            <div class="table-responsive">
                <table class="table table-bordered table-hover text-center">
                    <thead class="thead-dark">
                        <tr>
                            <th>#</th>
                            <th>Producto</th>
                            <th>Usuario</th>
                            <th>Sucursal Origen</th>
                            <th>Sucursal Destino</th>
                            <th>Cantidad</th>
                            <th>Fecha y Hora</th>
                            <th>Estado</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $traspasos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $traspaso): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($traspasos->firstItem() + $index); ?></td>
                                <td>
                                    <div class="text-left">
                                        <p><strong>📝 Nombre:</strong> <?php echo e($traspaso->producto->nombre); ?></p>
                                        <p><strong>🔖 Código 1:</strong> <?php echo e($traspaso->producto->codigo1 ?? 'N/A'); ?></p>
                                        <p><strong>🔖 Código 2:</strong> <?php echo e($traspaso->producto->codigo2 ?? 'N/A'); ?></p>
                                        <p><strong>📝 Descripción:</strong> <?php echo e($traspaso->producto->descripcion ?? 'Sin descripción'); ?></p>
                                    </div>
                                </td>
                                <td><?php echo e($traspaso->usuario->name); ?></td>
                                <td><?php echo e($traspaso->ubicacionOrigen->nombre ?? 'N/A'); ?></td>
                                <td><?php echo e($traspaso->ubicacionDestino->nombre ?? 'N/A'); ?></td>
                                <td><?php echo e($traspaso->cantidad); ?></td>
                                <td>
                                    <?php echo e(\Carbon\Carbon::parse($traspaso->fecha)->format('d/m/Y')); ?>

                                    <?php echo e(\Carbon\Carbon::parse($traspaso->created_at)->subHours(4)->format('H:i')); ?>

                                </td>
                                
                                <td>
                                    <span class="badge <?php echo e($traspaso->estado === 'enviado' ? 'badge-success' : 'badge-warning'); ?>">
                                        <?php echo e(ucfirst($traspaso->estado)); ?>

                                    </span>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center text-muted">No se encontraron registros de traspasos.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <!-- Paginación -->
            <div class="d-flex justify-content-center">
                <?php echo e($traspasos->appends(request()->all())->links()); ?>

            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\jugueteria\resources\views/traspasos/index.blade.php ENDPATH**/ ?>