<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title><?php echo e($pdfTitle); ?></title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; margin: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { border: 1px solid #000; padding: 8px; text-align: center; }
        th { background-color: #f2f2f2; }
    </style>
</head>
<body>
    <h2 style="text-align: center;">Reporte de Compras</h2>
    <p>Fecha de generación: <?php echo e(now()->format('d/m/Y H:i:s')); ?></p>
    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Producto</th>
                <th>Código 1</th>
                <th>Ubicación</th>
                <th>Cantidad</th>
                <th>Costo Total</th>
                <th>Usuario</th>
                <th>Fecha y Hora</th>
                <th>Observación</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $compras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $compra): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($index + 1); ?></td>
                    <td><?php echo e($compra->producto->nombre); ?></td>
                    <td><?php echo e($compra->producto->codigo1); ?></td>
                    <td><?php echo e($compra->ubicacion->nombre); ?></td>
                    <td><?php echo e($compra->cantidad); ?></td>
                    <td><?php echo e(number_format($compra->costo_total, 2)); ?> Bs.</td>
                    <td><?php echo e($compra->usuario->name); ?></td>
                    <td><?php echo e(\Carbon\Carbon::parse($compra->fecha_hora)->format('d/m/Y h:i A')); ?></td>
                    <td><?php echo e($compra->observacion ?? 'N/A'); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html>
<?php /**PATH /home/offsides/public_html/resources/views/compras/pdf.blade.php ENDPATH**/ ?>