

<?php $__env->startSection('content'); ?>
<section class="section">
    <!-- Encabezado -->
    <div class="section-header">
        <h3 class="page__heading text-primary font-weight-bold">📦 Gestión de Productos</h3>
    </div>
    <?php if($errors->has('file')): ?>
    <div class="alert alert-danger">
        <ul>
            <?php $__currentLoopData = $errors->get('file'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($message); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('super-administrador')): ?>
    <!-- Tipo de cambio -->
    <div class="card shadow-sm mb-4">
        <div class="card-body d-flex align-items-center justify-content-between">
            <form action="<?php echo e(route('mercancia.actualizarTipoCambio')); ?>" method="POST" class="d-flex align-items-center">
                <?php echo csrf_field(); ?>
                <label for="tipo_cambio" class="font-weight-bold mr-2">💱 Tipo de cambio (Bs.):</label>
                <input type="number" step="0.01" id="tipo_cambio" name="tipo_cambio" class="form-control form-control-sm mr-2" style="width: 100px;" value="<?php echo e($tipoCambio); ?>" required>
                <button type="submit" class="btn btn-primary btn-sm">Aplicar</button>
            </form>

            <?php if($tipoCambio != 1): ?>
                <form action="<?php echo e(route('mercancia.eliminarTipoCambio')); ?>" method="POST" class="d-inline-block">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-danger btn-sm">Reiniciar</button>
                </form>
            <?php endif; ?>
        </div>
    </div>
    <?php endif; ?>

    <!-- Filtros -->
    <div class="card shadow-sm mb-4">
        <div class="card-body d-flex justify-content-between align-items-center">
            <form action="<?php echo e(route('mercancia.index')); ?>" method="GET" class="form-inline">
                <label for="ubicacion_id" class="mr-2">📍 Filtrar por ubicación:</label>
                <select name="ubicacion_id" id="ubicacion_id" class="form-control mr-3">
                    <option value="">Todas</option>
                    <?php $__currentLoopData = $ubicaciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ubicacion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($ubicacion->id); ?>" <?php echo e(request('ubicacion_id') == $ubicacion->id ? 'selected' : ''); ?>>
                            <?php echo e($ubicacion->nombre); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <label for="searchInput" class="mr-2">🔍 Buscar:</label>
                <input type="text" name="q" id="searchInput" class="form-control mr-2" placeholder="Buscar..." value="<?php echo e(request('q')); ?>">
                <button type="submit" class="btn btn-primary">Aplicar</button>
                <a href="<?php echo e(route('mercancia.index')); ?>" class="btn btn-secondary ml-2">Reiniciar</a>
            </form>
        </div>
    </div>
  
    <!-- Acciones -->
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('administrador')): ?>
    <div class="mb-3 d-flex justify-content-between">
        <a href="<?php echo e(route('mercancia.create')); ?>" class="btn btn-success btn-sm shadow">➕ Agregar Producto</a>
        <form action="<?php echo e(route('mercancia.importar')); ?>" method="POST" enctype="multipart/form-data" class="d-inline-block">
            <?php echo csrf_field(); ?>
            <div class="custom-file d-inline-block">
                <input type="file" class="custom-file-input" id="file" name="file" required>
                <label class="custom-file-label" for="file">Seleccionar archivo</label>
            </div>
            <button type="submit" class="btn btn-success btn-sm shadow mt-2">📥 Importar</button>
        </form>
        <div class="d-flex justify-content-end">
            <form action="<?php echo e(route('mercancia.reporte.pdf')); ?>" method="GET" target="_blank">
                <input type="hidden" name="q" value="<?php echo e(request('q')); ?>">
                <input type="hidden" name="ubicacion_id" value="<?php echo e(request('ubicacion_id')); ?>">
                <button type="submit" class="btn btn-primary">📄 Ver Reporte PDF</button>
            </form>
        </div>
        
        
    </div>
    <?php endif; ?>

    <!-- Mensajes -->
    <?php if(session('success')): ?>
        <div class="alert alert-success mt-3 shadow-sm"><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    <?php if(session('error')): ?>
        <div class="alert alert-danger mt-3 shadow-sm"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

    <!-- Tabla de Productos -->
    <div class="card shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover table-bordered text-center">
                    <thead class="thead-dark">
                        <tr>
                            <th>Foto</th>
                            <th>Nombre</th>
                            <th>Código 1</th>
                            <th>Código 2</th>
                            <th>Descripción</th>
                            <th>PUF</th>
                            <th>PDF</th>
                            <th>PPF</th>
                            <th>PPN</th>
                            <th>PDN</th>
                            <th>PDC</th>
                            <th>Descuento (%)</th>
                            <th>Incremento (%)</th>
                            <th>Marca</th>
                            <th>Pcs/Paquete</th>
                            <th>Pcs/Caja</th>
                            <th>Ubicación</th>
                            <th>Posicion del producto</th>
                            <th>Cuarta, Media docena, Docena</th>
                            <th>Cantidad</th>
                            <th>Estado</th>
                 
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('super-administrador')): ?>
                                <th>Acciones</th>
                         <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $productos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php if($producto->foto): ?>
                                        <img src="<?php echo e(asset('storage/' . $producto->foto)); ?>"  class="img-thumbnail" style="max-width: 80px;">
                                        <?php echo e($producto->codigo1); ?>

                                    <?php else: ?>
                                        <span class="text-muted">No disponible</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($producto->nombre); ?></td>
                                <td><?php echo e($producto->codigo1); ?></td>
                                <td><?php echo e($producto->codigo2); ?></td>
                                <td><?php echo e($producto->descripcion); ?></td>
                                <td><?php echo e(number_format($producto->precio_unidad_facturado, 2)); ?> Bs.</td>
                                <td><?php echo e(number_format($producto->precio_docena_facturado, 2)); ?> Bs.</td>
                                <td><?php echo e(number_format($producto->precio_paquete_facturado, 2)); ?> Bs.</td>
                                <td><?php echo e(number_format($producto->precio_paquete_normal, 2)); ?> Bs.</td>
                                <td><?php echo e(number_format($producto->precio_docena_normal, 2)); ?> Bs.</td>
                                <td><?php echo e(number_format($producto->precio_docena_caja, 2)); ?> Bs.</td>
                                <td><?php echo e($producto->descuento); ?>%</td>
                                <td><?php echo e($producto->incremento); ?>%</td>
                                <td><?php echo e($producto->marca); ?></td>
                                <td><?php echo e($producto->piezas_por_paquete); ?></td>
                                <td><?php echo e($producto->piezas_por_caja); ?></td>
                                <td><?php echo e($producto->ubicacion->nombre ?? 'Sin ubicación'); ?></td>
                                <td><?php echo e($producto->posicion); ?></td>
                                <td>
                                    <?php if($producto->docena == 1): ?>
                                        <span class="badge badge-success" style="font-size: 1rem;">Sí</span>
                                    <?php else: ?>
                                        <span class="badge badge-danger" style="font-size: 1rem;">No</span>
                                    <?php endif; ?>
                                </td>
                                
                                <td><?php echo e($producto->cantidad); ?> Unidades</td>
                                <td>
                                    <span class="badge <?php echo e($producto->estado === 'activo' ? 'badge-success' : 'badge-secondary'); ?>">
                                        <?php echo e(ucfirst($producto->estado)); ?>

                                    </span>
                                </td>
                              
                                <?php if(auth()->user()->hasRole('Super administrador')): ?>
                                <td>
                                    <!-- Botón de editar -->
                                    <a href="<?php echo e(route('mercancia.edit', $producto)); ?>" class="btn btn-warning btn-sm">✏️ Editar</a>
                                
                                    <!-- Formulario para cambiar estado -->
                                    <form action="<?php echo e(route('mercancia.cambiarEstado', $producto)); ?>" method="POST" style="display:inline;">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-success btn-sm">🔄 Cambiar estado</button>
                                    </form>
                                
                                    <!-- Dropdown con enlaces directos -->
                                    <div class="dropdown d-inline-block">
                                        <button class="btn btn-info btn-sm dropdown-toggle" type="button" id="dropdownMenuButton<?php echo e($producto->id); ?>" data-bs-toggle="dropdown" aria-expanded="false">
                                            🖨️ Imprimir Sticker
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton<?php echo e($producto->id); ?>">
                                            <li>
                                                <a class="dropdown-item" href="<?php echo e(route('mercancia.generarSticker', $producto->id)); ?>" target="_blank">Sticker PUF 5x5</a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="<?php echo e(route('mercancia.generarStickerPPN', $producto->id)); ?>" target="_blank">Sticker PPN 5x5</a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="<?php echo e(route('mercancia.generarStickerPPNGrande', $producto->id)); ?>" target="_blank">Sticker PPN 10x15</a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="<?php echo e(route('mercancia.generarStickerPUFGrande', $producto->id)); ?>" target="_blank">Sticker PUF 10x15</a>
                                            </li>
                                        </ul>
                                    </div>
                                </td>
                                
                                
                                
                                <?php endif; ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div class="d-flex justify-content-center">
                    <?php echo e($productos->links()); ?>

                </div>
            </div>
        </div>
    </div>
</section>

<!-- Modal para mostrar la imagen ampliada -->
<div class="modal fade" id="imageModal" tabindex="-1" role="dialog" aria-labelledby="imageModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="imageModalLabel">Vista previa de la imagen</h5>
            </div>
            <div class="modal-body text-center">
                <img id="modalImage" src="" class="img-fluid" alt="Imagen del producto" style="max-height: 500px;">
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<script>
$(document).ready(function() {
    $('.img-thumbnail').on('click', function() {
        var imageUrl = $(this).attr('src'); 
        $('#modalImage').attr('src', imageUrl); 
        $('#imageModal').modal('show'); 
    });

    $('#imageModal').on('hidden.bs.modal', function () {
        $('#modalImage').attr('src', ''); 
    });
});
</script>
<script>
    $(document).ready(function() {
        // Inicializar Select2
        $('.select-sticker').select2({
            minimumResultsForSearch: Infinity, // Ocultar el cuadro de búsqueda
            width: '200px', // Ajustar ancho
            placeholder: "🖨️ Imprimir Sticker",
            allowClear: true // Permitir limpiar selección
        });
    });
</script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>

<style>

.modal-backdrop {
    background-color: rgba(0, 0, 0, 0.5); 
}
/* Estilización del botón dropdown */
.dropdown-toggle {
    border-radius: 5px;
    background-color: #17a2b8;
    color: white;
    font-weight: bold;
    padding: 6px 12px;
}

.dropdown-toggle:hover {
    background-color: #138496;
}

.dropdown-menu {
    border-radius: 8px;
    padding: 0;
    box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
}

.dropdown-item {
    padding: 10px 15px;
    font-size: 14px;
}

.dropdown-item:hover {
    background-color: #f8f9fa;
    color: #17a2b8;
}


</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/offsides/public_html/resources/views/mercancia/index.blade.php ENDPATH**/ ?>