<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Productos</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 20px;
        }

        header {
            text-align: center;
            margin-bottom: 20px;
        }

        header h1 {
            font-size: 20px;
            margin: 0;
        }

        header p {
            margin: 5px 0;
            font-size: 14px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th, td {
            border: 1px solid #ddd;
            padding: 5px;
            text-align: center;
        }

        th {
            background-color: #f4f4f4;
        }

        .total {
            text-align: right;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <header>
        <h1>Reporte de Productos</h1>
        <p>Generado el: <?php echo e(now()->format('d/m/Y H:i:s')); ?></p>
    </header>
    <table>
        <thead>
            <tr>
                <th>Nombre</th>
                <th>Código 1</th>
                <th>Código 2</th>
                <th>Descripción</th>
                <th>Marca</th>
                <th>Cantidad</th>
                <th>Ubicación</th>
                <th>Posición</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $productos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($producto->nombre); ?></td>
                    <td><?php echo e($producto->codigo1); ?></td>
                    <td><?php echo e($producto->codigo2); ?></td>
                    <td><?php echo e($producto->descripcion); ?></td>
                    <td><?php echo e($producto->marca); ?></td>
                    <td><?php echo e($producto->cantidad); ?></td>
                    <td><?php echo e($producto->ubicacion->nombre ?? 'No especificada'); ?></td>
                    <td><?php echo e($producto->posicion); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html>
<?php /**PATH /home/elcomerc/public_html/resources/views/mercancia/reporte_pdf.blade.php ENDPATH**/ ?>