<?php $__env->startSection('content'); ?>
<section class="section">
    <div class="section-header">
        <h3 class="page__heading">Inicio</h3>
    </div>

    <!-- Mensaje de Bienvenida -->
    <div class="alert alert-info">
        <h5 class="text-center">¡Bienvenido, <?php echo e(Auth::user()->name); ?>! 😊</h5>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('administrador')): ?>
        <p class="text-center mb-0">Aquí puedes consultar el estado general del sistema, las sucursales, productos y ventas.</p>
        <?php endif; ?>
    </div>
<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('administrador')): ?>
    <!-- Resumen General -->
    <div class="row">
        <div class="col-lg-4 col-md-6 col-sm-12">
            <div class="card card-statistic-1">
                <div class="card-icon bg-primary">
                    <i class="fas fa-store"></i>
                </div>
                <div class="card-wrap">
                    <div class="card-header">
                        <h4>Sucursales</h4>
                    </div>
                    <div class="card-body">
                        <?php echo e($totalSucursales); ?>

                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4 col-md-6 col-sm-12">
            <div class="card card-statistic-1">
                <div class="card-icon bg-success">
                    <i class="fas fa-user"></i>
                </div>
                <div class="card-wrap">
                    <div class="card-header">
                        <h4>Empleados</h4>
                    </div>
                    <div class="card-body">
                        <?php echo e($totalEmpleados); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Productos con Bajo Stock -->
    <div class="card">
        <div class="card-header bg-warning text-white">
            <h4 class="mb-0">Productos con Bajo Stock</h4>
        </div>
        <div class="card-body">
            <table class="table table-striped table-hover">
                <thead class="bg-light">
                    <tr>
                        <th>Producto</th>
                        <th>Código</th>
                        <th>Cantidad</th>
                        <th>Ubicación</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $productosConBajoStock; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($producto->nombre); ?></td>
                            <td><?php echo e($producto->codigo1); ?></td>
                            <td><?php echo e($producto->cantidad); ?></td>
                            <td><?php echo e($producto->ubicacion->nombre ?? 'No especificada'); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="4" class="text-center">No hay productos con bajo stock.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Productos Más Vendidos -->
    <div class="card">
        <div class="card-header bg-success text-white">
            <h4 class="mb-0">Productos Más Vendidos</h4>
        </div>
        <div class="card-body">
            <table class="table table-striped table-hover">
                <thead class="bg-light">
                    <tr>
                        <th>Producto</th>
                        <th>Código</th>
                        <th>Total Vendido</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $productosMasVendidos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($producto->nombre); ?></td>
                            <td><?php echo e($producto->codigo1); ?></td>
                            <td><?php echo e($producto->total_vendido); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="3" class="text-center">No hay productos vendidos aún.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Ventas por Fecha -->
    <div class="card">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0" style="color: azure">Ventas por Fecha</h4>
        </div>
        <div class="card-body">
            <table class="table table-striped table-hover">
                <thead class="bg-light">
                    <tr>
                        <th>Fecha</th>
                        <th>Total Vendido</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $ventasPorFecha; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($venta->fecha); ?></td>
                            <td><?php echo e($venta->total_ventas); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="2" class="text-center">No hay ventas registradas.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
            <div class="d-flex justify-content-center">
                <?php echo e($ventasPorFecha->links()); ?>

            </div>
        </div>
    </div>
</section>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elcomerc/public_html/resources/views/home.blade.php ENDPATH**/ ?>