

<?php $__env->startSection('content'); ?>
<section class="section">
    <div class="section-header d-flex justify-content-between align-items-center">
        <h3 class="page__heading">🛒 Registro de Compras</h3>
        <a href="<?php echo e(route('compras.create')); ?>" class="btn btn-primary shadow">
            <i class="fas fa-plus-circle me-2"></i> Nueva Compra
        </a>
    </div>

    <!-- Filtros -->
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <form action="<?php echo e(route('compras.index')); ?>" method="get" class="row align-items-end">
                <!-- Buscar por producto -->
                <div class="col-md-3 mb-3">
                    <label for="search">🔍 Buscar producto:</label>
                    <input type="text" name="search" class="form-control" placeholder="Nombre, Código o Descripción" value="<?php echo e(request('search')); ?>">
                </div>

                <!-- Filtrar por ubicación -->
                <div class="col-md-3 mb-3">
                    <label for="ubicacion_id">📍 Ubicación:</label>
                    <select name="ubicacion_id" class="form-control select2">
                        <option value="">Todas</option>
                        <?php $__currentLoopData = $ubicaciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ubicacion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($ubicacion->id); ?>" <?php echo e(request('ubicacion_id') == $ubicacion->id ? 'selected' : ''); ?>>
                                <?php echo e($ubicacion->nombre); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Filtrar por período -->
                <div class="col-md-4 mb-3">
                    <label>📅 Período:</label>
                    <div class="input-group">
                        <input type="date" name="start_date" class="form-control" value="<?php echo e(request('start_date')); ?>">
                        <span class="input-group-text">a</span>
                        <input type="date" name="end_date" class="form-control" value="<?php echo e(request('end_date')); ?>">
                    </div>
                </div>

                <!-- Botones de acción -->
                <div class="col-md-2 mb-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="fas fa-search me-2"></i> Filtrar
                    </button>
                </div>
            </form>

            <!-- Botones adicionales -->
            <div class="d-flex justify-content-between">
                <a href="<?php echo e(route('compras.index')); ?>" class="btn btn-secondary shadow">
                    <i class="fas fa-sync-alt me-2"></i> Ver Todas
                </a>

                <form action="<?php echo e(route('compras.generatePDF')); ?>" method="GET" class="d-flex align-items-center">
                    <input type="hidden" name="search" value="<?php echo e(request('search')); ?>">
                    <input type="hidden" name="ubicacion_id" value="<?php echo e(request('ubicacion_id')); ?>">
                    <input type="hidden" name="start_date" value="<?php echo e(request('start_date')); ?>">
                    <input type="hidden" name="end_date" value="<?php echo e(request('end_date')); ?>">
                    <button type="submit" class="btn btn-success shadow">
                        <i class="fas fa-file-pdf me-2"></i> Generar Reporte PDF
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- Tabla de compras -->
    <div class="card shadow-sm">
        <div class="card-body">
            <h4 class="mb-4 text-primary">📄 Compras Registradas</h4>
            <div class="table-responsive">
                <table class="table table-hover table-bordered text-center align-middle">
                    <thead class="thead-dark">
                        <tr>
                            <th>#</th>
                            <th>Producto</th>
                            <th>Ubicación</th>
                            <th>Cantidad</th>
                            <th>Costo Total</th>
                            <th>Detalles del Producto</th>
                            <th>Usuario</th>
                            <th>Fecha y Hora</th>
                            <th>Observación</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $compras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $compra): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($compras->firstItem() + $index); ?></td>
                                <td><?php echo e($compra->producto->nombre); ?></td>
                                <td><?php echo e($compra->ubicacion->nombre); ?></td>
                                <td><?php echo e($compra->cantidad); ?></td>
                                <td><?php echo e(number_format($compra->costo_total, 2)); ?> Bs.</td>
                                <td class="text-start">
                                    <p><strong>🔖 Código 1:</strong> <?php echo e($compra->producto->codigo1 ?? 'N/A'); ?></p>
                                    <p><strong>🔖 Código 2:</strong> <?php echo e($compra->producto->codigo2 ?? 'N/A'); ?></p>
                                    <p><strong>📊 Cantidad Actual:</strong> <?php echo e($compra->producto->cantidad ?? 0); ?></p>
                                    <p><strong>📝 Descripción:</strong> <?php echo e($compra->producto->descripcion ?? 'Sin descripción'); ?></p>
                                    <p><strong>🏷 Pizas/Caja:</strong> <?php echo e($compra->producto->piezas_por_paquete ?? 'N/A'); ?></p>
                                    <p><strong>🏷 Pizas/Paquete:</strong> <?php echo e($compra->producto->piezas_por_caja ?? 'N/A'); ?></p>
                                </td>
                                <td><?php echo e($compra->usuario->name); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($compra->fecha_hora)->subHours(4)->format('d/m/Y h:i A')); ?></td>
                                <td><?php echo e($compra->observacion ?? 'N/A'); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="9" class="text-center text-muted">No hay compras registradas.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Paginación -->
            <div class="d-flex justify-content-center mt-4">
                <?php echo e($compras->appends(request()->query())->links()); ?>

            </div>
        </div>
    </div>
</section>

<?php $__env->startSection('scripts'); ?>
<script>
    $(document).ready(function() {
        $('.select2').select2({
            placeholder: "Seleccione una opción",
            allowClear: true
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/offsides/public_html/resources/views/compras/index.blade.php ENDPATH**/ ?>