<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Resumen de Venta</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 20px;
            color: #333;
        }

        header {
            text-align: center;
            margin-bottom: 20px;
        }

        header h1 {
            font-size: 20px;
            margin: 0;
            color: #555;
        }

        header p {
            margin: 5px 0;
            font-size: 12px;
            color: #666;
        }

        .venta-info {
            margin-bottom: 20px;
            font-size: 12px;
        }

        .venta-info p {
            margin: 5px 0;
            line-height: 1.5;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: center;
            vertical-align: middle;
        }

        th {
            background-color: #f8f8f8;
            font-weight: bold;
            color: #333;
        }

        tr:nth-child(even) {
            background-color: #f9f9f9;
        }

        tr:hover {
            background-color: #f1f1f1;
        }

        .total {
            text-align: right;
            margin-top: 20px;
            font-size: 14px;
            font-weight: bold;
            color: #333;
        }

        .nota {
            margin-top: 20px;
            font-size: 12px;
            color: #555;
            text-align: justify;
        }

        .nota strong {
            color: #333;
        }
    </style>
</head>
<body>
    <header>
        <h1>Resumen de Venta</h1>
        <p>Generado el: {{ now()->subHours(4)->format('d/m/Y H:i:s') }}</p>
          <p><strong>Codigo:</strong> {{ $venta->codigo}}</p>
    </header>

    <div class="venta-info">
        <p><strong>Nombre:</strong> {{ $venta->cliente->nombre ?? '__________________________' }} {{ $venta->cliente->apellidos ?? '__________________________' }}</p>

        <p><strong>Destino:</strong> __________________________</p>
        <p><strong>NIT:</strong> {{ $venta->cliente->carnet ?? '__________________________' }}</p>
        <p><strong>Transportadora:</strong> __________________________</p>
        <p><strong>Fecha:</strong> {{ \Carbon\Carbon::parse($venta->fecha)->format('d/m/Y') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Cantidad</th>
                <th>Descripción / Código</th>
                <th>Precio</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            @foreach($venta->productosVendidos as $productoVendido)
                <tr>
                    <td>{{ $productoVendido->cantidad }} {{ $productoVendido->tipo_medida }}</td>
                    <td>{{ $productoVendido->producto->nombre }} ({{ $productoVendido->producto->codigo1 }})</td>
                    <td>{{ number_format($productoVendido->precio, 2) }} Bs. X {{ ($productoVendido->cantidad_total) }}</td>
                    <td>{{ number_format($productoVendido->precio_total, 2) }} Bs.</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="total">
        <p>Total Venta: {{ number_format($venta->precio_total, 2) }} Bs.</p>
    </div>

    <div class="nota">
        <p><strong>Nota:</strong> Por favor, revise cuidadosamente los productos entregados. Cualquier reclamo o solicitud de ajuste deberá realizarse dentro de un plazo máximo de <strong>10 días calendario</strong> a partir de la fecha de compra. Pasado este periodo, no se aceptarán cambios ni devoluciones.</p>
    </div>

    <p><strong>Observaciones:</strong> {{ $venta->observacion ?? '__________________________' }}</p>

</body>
</html>
