@extends('layouts.app')

@section('content')
<section class="section">
    <!-- Encabezado -->
    <div class="section-header d-flex justify-content-between align-items-center">
        <h3 class="page__heading">🛒 Gestión de Ventas</h3>
        <a href="{{ route('ventas.create') }}" class="btn btn-primary shadow">➕ Realizar Venta</a>
    </div>
 <!-- Recursos SweetAlert2 -->
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <!-- Mensajes -->
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif
    @if($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <ul>
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif
    @can('administrador')
 <!-- Filtros de búsqueda -->
<div class="card shadow-sm mb-4">
    <div class="card-body">
        <h5 class="card-title">🔍 Filtros de búsqueda</h5>
        <form action="{{ route('ventas.index') }}" method="get">
            <div class="row g-3">
                <div class="col-md-3">
                    <label for="search">Buscar por Código o Producto:</label>
                    <input type="text" name="search" class="form-control" placeholder="Código, nombre o descripción" value="{{ request('search') }}">
                </div>
                <div class="col-md-3">
                    <label for="cliente">Buscar por Cliente:</label>
                    <input type="text" name="cliente" class="form-control" placeholder="Nombre, Apellido o Carnet" value="{{ request('cliente') }}">
                </div>
                <div class="col-md-3">
                    <label for="user_id">Filtrar por Vendedor:</label>
                    <select name="user_id" id="user_id" class="select2 form-control">
                        <option value="">Seleccionar vendedor</option>
                        @foreach($usuariosAprobadores as $usuario)
                            <option value="{{ $usuario->id }}" {{ request('user_id') == $usuario->id ? 'selected' : '' }}>
                                {{ $usuario->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <label>Periodo de fechas:</label>
                    <div class="input-group">
                        <input type="date" name="start_date" class="form-control" value="{{ request('start_date') }}">
                        <span class="input-group-text">a</span>
                        <input type="date" name="end_date" class="form-control" value="{{ request('end_date') }}">
                    </div>
                </div>
                <div class="col-md-3">
                    <label for="ubicacion">Ubicación:</label>
                    <select name="ubicacion" id="ubicacion" class="form-control">
                        <option value="">Todas</option>
                        @foreach($ubicaciones as $ubicacion)
                            <option value="{{ $ubicacion->id }}" {{ request('ubicacion') == $ubicacion->id ? 'selected' : '' }}>
                                {{ $ubicacion->nombre }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="estado">Estado:</label>
                    <select name="estado" id="estado" class="form-control">
                        <option value="">Todos</option>
                        <option value="0" {{ request('estado') == '0' ? 'selected' : '' }}>Pendiente</option>
                        <option value="1" {{ request('estado') == '1' ? 'selected' : '' }}>Aprobada</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="usuario_aprobador">Usuario Aprobador:</label>
                    <select name="usuario_aprobador" id="usuario_aprobador" class="select2 form-control">
                        <option value="">Seleccionar Aprobador</option>
                        @foreach($usuariosAprobadores as $usuario)
                            <option value="{{ $usuario->id }}" {{ request('usuario_aprobador') == $usuario->id ? 'selected' : '' }}>
                                {{ $usuario->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary mx-2">🔎 Buscar</button>
                    <a href="{{ route('ventas.index') }}" class="btn btn-secondary">🔄 Reiniciar</a>
                </div>
            </div>
        </form>
    </div>
    <div class="card-body">
        <h5 class="card-title">📥 Descargar reporte</h5>
        <form action="{{ route('ventas.generatePDF') }}" method="get" class="d-flex align-items-center">
            @csrf
            <!-- Pasar filtros al reporte -->
            <input type="hidden" name="search" value="{{ request('search') }}">
            <input type="hidden" name="cliente" value="{{ request('cliente') }}">
            <input type="hidden" name="user_id" value="{{ request('user_id') }}">
            <input type="hidden" name="start_date" value="{{ request('start_date') }}">
            <input type="hidden" name="end_date" value="{{ request('end_date') }}">
            <input type="hidden" name="estado" value="{{ request('estado') }}">
            <input type="hidden" name="ubicacion" value="{{ request('ubicacion') }}">
            <input type="hidden" name="usuario_aprobador" value="{{ request('usuario_aprobador') }}">
            <input type="text" name="pdfName" class="form-control w-50" placeholder="Nombre del PDF">
            <button type="submit" class="btn btn-success ms-3">📥 Descargar PDF</button>
        </form>
    </div>
</div>

@endcan


    <!-- Lista de Ventas -->
<div class="row">
    @forelse($ventasPaginadas as $venta)
        <div class="col-md-12">
            <div class="card shadow-sm mb-4">
                <div class="card-header d-flex justify-content-between align-items-center" 
                    style="background-color: 
                        @if($venta->estado == 1) 
                            #28a745 
                        @elseif($venta->estado == 2)
                            #dc3545
                        @else
                            #ffc107
                        @endif; color: white;">
                    <h6 class="mb-0">🛒 Código: {{ $venta->codigo }}</h6>
                    <span>
                        <strong>Total: {{ number_format($venta->precio_total, 2) }} Bs.</strong> 
                        <span class="badge 
                            @if($venta->estado == 1) 
                                bg-success 
                            @elseif($venta->estado == 2) 
                                bg-danger
                            @else
                                bg-warning text-dark
                            @endif">
                            @if($venta->estado == 1) 
                                Aprobada 
                            @elseif($venta->estado == 2) 
                                Rechazada
                            @else 
                                Pendiente
                            @endif
                        </span>
                    </span>
                </div>
                <div class="card-body">
                    <!-- Detalles de la venta -->
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <p><strong>Usuario:</strong> {{ $venta->usuario->name }}</p>
                            <p><strong>Estado:</strong> 
                                @if($venta->estado == 1)
                                    Aprobada
                                @elseif($venta->estado == 2)
                                    Rechazada
                                @else
                                    Pendiente
                                @endif
                            </p>
                            <p><strong>Fecha:</strong> {{ \Carbon\Carbon::parse($venta->fecha)->format('d/m/Y') }}</p>
                            <p><strong>Hora:</strong> {{ \Carbon\Carbon::parse($venta->hora)->subHours(4)->format('H:i:s') }}</p>
                            <p><strong>Ubicación:</strong> 
                                {{ $venta->productosVendidos->pluck('producto.ubicacion.nombre')->unique()->implode(', ') ?? 'No especificada' }}
                            </p>
                            @if($venta->estado == 1 && $venta->usuarioAprobador)
                                <p><strong>Aprobada por:</strong> {{ $venta->usuarioAprobador->name }}</p>
                            @endif
                            @if($venta->estado == 2 && $venta->usuarioRechazador)
                                <p><strong>Rechazada por:</strong> {{ $venta->usuarioRechazador->name }}</p>
                            @endif
                            @if($venta->estado == 2)
                            <p><strong>Fecha de rechazo:</strong> 
                                {{ \Carbon\Carbon::parse($venta->updated_at)->subHours(4)->format('d/m/Y H:i:s') }}
                            </p>
                        @endif
                        @if($venta->cliente)
                        <p><strong>Cliente:</strong> {{ $venta->cliente->nombre }} {{ $venta->cliente->apellidos }}</p>
                        <p><strong>Carnet:</strong> {{ $venta->cliente->carnet }}</p>
                    @else
                        <p><strong>Cliente:</strong> No asignado</p>
                        <p><strong>Carnet:</strong> No disponible</p>
                    @endif
                    
                      @if($venta->observacion)
                        <p><strong>Observaciones:</strong> {{ $venta->observacion }}</p>
                    @else
                        <p><strong>Observaciones:</strong> No hay observaciones</p>
                    @endif
                    
                        @can('administrador')
                                @if($venta->estado == 1)
                                <div class="d-flex flex-wrap gap-3 justify-content-start">
                                    <a href="{{ route('ventas.resumen', $venta->id) }}" target="_blank" class="btn btn-primary btn-lg px-4 py-2 shadow-sm">
                                        📄 Generar Venta para Cliente
                                    </a>
                                    <a href="{{ route('ventas.almacen', $venta->id) }}" target="_blank" class="btn btn-warning btn-lg px-4 py-2 shadow-sm">
                                        📄 Venta para Almacen
                                    </a>
                                    <a href="{{ route('ventas.simple', $venta->id) }}" target="_blank" class="btn btn-success btn-lg px-4 py-2 shadow-sm">
                                        📄 Generar Resumen de Venta para Cliente
                                    </a>
                                </div>
                            @endif
                            @endcan
                        
                        </div>
                    </div>

                    <!-- Tabla de Productos Vendidos -->
                    <div class="table-responsive">
                        <h6 class="text-primary">📋 Productos Vendidos</h6>
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>Producto</th>
                                    <th>Código</th>
                                    <th>Descripción</th>
                                    <th>Ubicación</th>
                                    <th>Marca</th>
                                    <th>Tipo de Precio</th>
                                    <th>Medida</th>
                                    <th>Cantidad</th>
                                    <th>Cantidad Total</th>
                                    <th>Precio  (Bs.)</th>
                                    <th>Total (Bs.)</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($venta->productosVendidos as $productoVendido)
                                    <tr>
                                        <td>{{ $productoVendido->producto->nombre }}</td>
                                        <td>{{ $productoVendido->producto->codigo1 }}</td>
                                        <td>{{ $productoVendido->producto->descripcion }}</td>
                                        <td>{{ $productoVendido->producto->ubicacion->nombre ?? 'No especificada' }}</td>
                                        <td>{{ $productoVendido->producto->marca }}</td>
                                        <td>{{ $productoVendido->tipo_precio }}</td>
                                        <td>{{ $productoVendido->tipo_medida }}</td>
                                        <td>{{ $productoVendido->cantidad }}</td>
                                        <td>{{ $productoVendido->cantidad_total }}</td>
                                        <td>{{ number_format($productoVendido->precio, 2) }}</td>
                                        <td>{{ number_format($productoVendido->precio_total, 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
@can('administrador')
                    <!-- Botón para Aprobar o Rechazar Venta -->
                    @if($venta->estado == 0)
                        <button class="btn btn-success btn-sm" onclick="aprobarVentaSweet('{{ $venta->id }}', '{{ $venta->codigo }}')">
                            ✅ Aprobar
                        </button>
                        <button class="btn btn-danger btn-sm" onclick="rechazarVentaSweet('{{ $venta->id }}', '{{ $venta->codigo }}')">
                            ❌ Rechazar
                        </button>
                    @endif
                    @endcan
                </div>
            </div>
        </div>
    @empty
        <div class="text-center text-muted">No hay ventas registradas.</div>
    @endforelse
</div>


    <!-- Paginación -->
    <div class="d-flex justify-content-center mt-4">
        {{ $ventasPaginadas->links() }}
    </div>
</section>

<script>
    function rechazarVentaSweet(ventaId, codigo) {
    Swal.fire({
        title: '¿Estás seguro?',
        text: `¿Deseas rechazar la venta con código ${codigo}?`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#28a745',
        confirmButtonText: 'Sí, rechazar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            // Realizar la solicitud AJAX para rechazar la venta
            $.ajax({
                url: `/public/ventas/${ventaId}/rechazar`,
                method: 'PATCH',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                contentType: 'application/json',
                success: function(response) {
                    Swal.fire(
                        '¡Rechazada!',
                        'La venta ha sido rechazada y los productos han sido devueltos al inventario.',
                        'success'
                    ).then(() => location.reload());
                },
                error: function(xhr, status, error) {
                    Swal.fire(
                        'Error',
                        'No se pudo rechazar la venta. Por favor, inténtalo nuevamente.',
                        'error'
                    );
                }
            });
        }
    });
}

</script>
<!-- Script para SweetAlert2 -->
<script>

function aprobarVentaSweet(ventaId, codigo) {
    Swal.fire({
        title: '¿Estás seguro?',
        text: `¿Deseas aprobar la venta con código ${codigo}?`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Sí, aprobar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            // Realizar la solicitud AJAX para aprobar la venta
            $.ajax({
                url: `/public/ventas/${ventaId}/aprobar`,
                method: 'PATCH',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                contentType: 'application/json',
                success: function(response) {
                    Swal.fire(
                        '¡Aprobada!',
                        'La venta ha sido aprobada.',
                        'success'
                    ).then(() => location.reload());
                },
                error: function(xhr, status, error) {
                    if (xhr.responseJSON && xhr.responseJSON.error) {
                        Swal.fire(
                            'Error',
                            xhr.responseJSON.error,
                            'error'
                        );
                    } else {
                        Swal.fire(
                            'Error',
                            'No se pudo aprobar la venta. Por favor, inténtalo nuevamente.',
                            'error'
                        );
                    }
                }
            });
        }
    });
}

</script>
@endsection
