@extends('layouts.app')

@section('content')
<section class="section">
    <div class="section-header d-flex justify-content-between align-items-center">
        <h3 class="page__heading">📦 Traspasos de Productos</h3>
        <a href="{{ route('traspasos.showFormEnviarProducto') }}" class="btn btn-primary shadow">➕ Enviar Producto</a>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <!-- Filtros -->
    <div class="card mb-4 shadow-sm">
        <div class="card-body">
            <form action="{{ route('traspasos.index') }}" method="get" class="row align-items-end">
                <div class="col-md-3">
                    <label for="search">🔍 Buscar producto:</label>
                    <input type="text" name="search" class="form-control" placeholder="Nombre del producto" value="{{ request('search') }}">
                </div>
                <div class="col-md-3">
                    <label for="ubicacion_origen_id">📍 Sucursal Origen:</label>
                    <select name="ubicacion_origen_id" class="form-control">
                        <option value="">Todas</option>
                        @foreach($ubicaciones as $ubicacion)
                            <option value="{{ $ubicacion->id }}" {{ request('ubicacion_origen_id') == $ubicacion->id ? 'selected' : '' }}>
                                {{ $ubicacion->nombre }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="ubicacion_destino_id">📍 Sucursal Destino:</label>
                    <select name="ubicacion_destino_id" class="form-control">
                        <option value="">Todas</option>
                        @foreach($ubicaciones as $ubicacion)
                            <option value="{{ $ubicacion->id }}" {{ request('ubicacion_destino_id') == $ubicacion->id ? 'selected' : '' }}>
                                {{ $ubicacion->nombre }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-primary btn-block">🔎 Filtrar</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Tabla de Traspasos -->
    <div class="card shadow-sm">
        <div class="card-body">
            <h4 class="mb-4 text-primary">📄 Registro de Traspasos</h4>
            <div class="table-responsive">
                <table class="table table-bordered table-hover text-center">
                    <thead class="thead-dark">
                        <tr>
                            <th>#</th>
                            <th>Producto</th>
                            <th>Usuario</th>
                            <th>Sucursal Origen</th>
                            <th>Sucursal Destino</th>
                            <th>Cantidad</th>
                            <th>Fecha y Hora</th>
                            <th>Estado</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($traspasos as $index => $traspaso)
                            <tr>
                                <td>{{ $traspasos->firstItem() + $index }}</td>
                                <td>
                                    <div class="text-left">
                                        <p><strong>📝 Nombre:</strong> {{ $traspaso->producto->nombre }}</p>
                                        <p><strong>🔖 Código 1:</strong> {{ $traspaso->producto->codigo1 ?? 'N/A' }}</p>
                                        <p><strong>🔖 Código 2:</strong> {{ $traspaso->producto->codigo2 ?? 'N/A' }}</p>
                                        <p><strong>📝 Descripción:</strong> {{ $traspaso->producto->descripcion ?? 'Sin descripción' }}</p>
                                    </div>
                                </td>
                                <td>{{ $traspaso->usuario->name }}</td>
                                <td>{{ $traspaso->ubicacionOrigen->nombre ?? 'N/A' }}</td>
                                <td>{{ $traspaso->ubicacionDestino->nombre ?? 'N/A' }}</td>
                                <td>{{ $traspaso->cantidad }}</td>
                                <td>
                                    {{ \Carbon\Carbon::parse($traspaso->fecha)->format('d/m/Y') }}
                                    {{ \Carbon\Carbon::parse($traspaso->created_at)->subHours(4)->format('H:i') }}
                                </td>
                                
                                <td>
                                    <span class="badge {{ $traspaso->estado === 'enviado' ? 'badge-success' : 'badge-warning' }}">
                                        {{ ucfirst($traspaso->estado) }}
                                    </span>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center text-muted">No se encontraron registros de traspasos.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <!-- Paginación -->
            <div class="d-flex justify-content-center">
                {{ $traspasos->appends(request()->all())->links() }}
            </div>
        </div>
    </div>
</section>
@endsection
