@foreach($productos as $producto)
    <tr>
        <td>{{ $producto->nombre }}</td>
        <td>{{ $producto->codigo1 }}</td>
        <td>{{ $producto->codigo2 }}</td>
        <td>{{ $producto->descripcion }}</td>
        <td>{{ number_format($producto->precio1, 2) }} Bs.</td>
        <td>{{ number_format($producto->precio2, 2) }} Bs.</td>
        <td>{{ $producto->marca }}</td>
        <td>{{ $producto->cantidad }} Unidades</td>
        <td>{{ ucfirst($producto->estado) }}</td>
        <!-- Puedes agregar más campos según lo necesites -->
    </tr>
@endforeach
<!-- Modal -->
<div class="modal fade" id="productModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Imagen del Producto</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <img id="productImage" src="" alt="Imagen del Producto" style="max-width: 100%;">
            </div>
        </div>
    </div>
</div>

<!-- JavaScript para mostrar el modal -->
<script>
    $(document).ready(function() {
        $('.product-image').click(function() {
            var imageUrl = $(this).data('image');
            $('#productImage').attr('src', imageUrl);
            $('#productModal').modal('show');
        });
    });
</script>
