@extends('layouts.app')

@section('content')
<section class="section">
    <!-- Encabezado -->
    <div class="section-header">
        <h3 class="page__heading text-primary font-weight-bold">📦 Gestión de Productos</h3>
    </div>
    @if ($errors->has('file'))
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->get('file') as $message)
                <li>{{ $message }}</li>
            @endforeach
        </ul>
    </div>
@endif

    @can('super-administrador')
    <!-- Tipo de cambio -->
    <div class="card shadow-sm mb-4">
        <div class="card-body d-flex align-items-center justify-content-between">
            <form action="{{ route('mercancia.actualizarTipoCambio') }}" method="POST" class="d-flex align-items-center">
                @csrf
                <label for="tipo_cambio" class="font-weight-bold mr-2">💱 Tipo de cambio (Bs.):</label>
                <input type="number" step="0.01" id="tipo_cambio" name="tipo_cambio" class="form-control form-control-sm mr-2" style="width: 100px;" value="{{ $tipoCambio }}" required>
                <button type="submit" class="btn btn-primary btn-sm">Aplicar</button>
            </form>

            @if($tipoCambio != 1)
                <form action="{{ route('mercancia.eliminarTipoCambio') }}" method="POST" class="d-inline-block">
                    @csrf
                    <button type="submit" class="btn btn-danger btn-sm">Reiniciar</button>
                </form>
            @endif
        </div>
    </div>
    @endcan

    <!-- Filtros -->
    <div class="card shadow-sm mb-4">
        <div class="card-body d-flex justify-content-between align-items-center">
            <form action="{{ route('mercancia.index') }}" method="GET" class="form-inline">
                <label for="ubicacion_id" class="mr-2">📍 Filtrar por ubicación:</label>
                <select name="ubicacion_id" id="ubicacion_id" class="form-control mr-3">
                    <option value="">Todas</option>
                    @foreach($ubicaciones as $ubicacion)
                        <option value="{{ $ubicacion->id }}" {{ request('ubicacion_id') == $ubicacion->id ? 'selected' : '' }}>
                            {{ $ubicacion->nombre }}
                        </option>
                    @endforeach
                </select>
                <label for="searchInput" class="mr-2">🔍 Buscar:</label>
                <input type="text" name="q" id="searchInput" class="form-control mr-2" placeholder="Buscar..." value="{{ request('q') }}">
                <button type="submit" class="btn btn-primary">Aplicar</button>
                <a href="{{ route('mercancia.index') }}" class="btn btn-secondary ml-2">Reiniciar</a>
            </form>
        </div>
    </div>
  
    <!-- Acciones -->
    @can('administrador')
    <div class="mb-3 d-flex justify-content-between">
        <a href="{{ route('mercancia.create') }}" class="btn btn-success btn-sm shadow">➕ Agregar Producto</a>
        <form action="{{ route('mercancia.importar') }}" method="POST" enctype="multipart/form-data" class="d-inline-block">
            @csrf
            <div class="custom-file d-inline-block">
                <input type="file" class="custom-file-input" id="file" name="file" required>
                <label class="custom-file-label" for="file">Seleccionar archivo</label>
            </div>
            <button type="submit" class="btn btn-success btn-sm shadow mt-2">📥 Importar</button>
        </form>
        <div class="d-flex justify-content-end">
            <form action="{{ route('mercancia.reporte.pdf') }}" method="GET" target="_blank">
                <input type="hidden" name="q" value="{{ request('q') }}">
                <input type="hidden" name="ubicacion_id" value="{{ request('ubicacion_id') }}">
                <button type="submit" class="btn btn-primary">📄 Ver Reporte PDF</button>
            </form>
        </div>
        
        
    </div>
    @endcan

    <!-- Mensajes -->
    @if(session('success'))
        <div class="alert alert-success mt-3 shadow-sm">{{ session('success') }}</div>
    @endif
    @if(session('error'))
        <div class="alert alert-danger mt-3 shadow-sm">{{ session('error') }}</div>
    @endif

    <!-- Tabla de Productos -->
    <div class="card shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover table-bordered text-center">
                    <thead class="thead-dark">
                        <tr>
                            <th>Foto</th>
                            <th>Nombre</th>
                            <th>Código 1</th>
                            <th>Código 2</th>
                            <th>Descripción</th>
                            <th>PUF</th>
                            <th>PDF</th>
                            <th>PPF</th>
                            <th>PPN</th>
                            <th>PDN</th>
                            <th>PDC</th>
                            <th>Descuento (%)</th>
                            <th>Incremento (%)</th>
                            <th>Marca</th>
                            <th>Pcs/Paquete</th>
                            <th>Pcs/Caja</th>
                            <th>Ubicación</th>
                            <th>Posicion del producto</th>
                            <th>Cuarta, Media docena, Docena</th>
                            <th>Cantidad</th>
                            <th>Estado</th>
                 
                            @can('super-administrador')
                                <th>Acciones</th>
                         @endcan
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($productos as $producto)
                            <tr>
                                <td>
                                    @if($producto->foto)
                                        <img src="{{ asset('storage/' . $producto->foto) }}"  class="img-thumbnail" style="max-width: 80px;">
                                        {{ $producto->codigo1 }}
                                    @else
                                        <span class="text-muted">No disponible</span>
                                    @endif
                                </td>
                                <td>{{ $producto->nombre }}</td>
                                <td>{{ $producto->codigo1 }}</td>
                                <td>{{ $producto->codigo2 }}</td>
                                <td>{{ $producto->descripcion }}</td>
                                <td>{{ number_format($producto->precio_unidad_facturado, 2) }} Bs.</td>
                                <td>{{ number_format($producto->precio_docena_facturado, 2) }} Bs.</td>
                                <td>{{ number_format($producto->precio_paquete_facturado, 2) }} Bs.</td>
                                <td>{{ number_format($producto->precio_paquete_normal, 2) }} Bs.</td>
                                <td>{{ number_format($producto->precio_docena_normal, 2) }} Bs.</td>
                                <td>{{ number_format($producto->precio_docena_caja, 2) }} Bs.</td>
                                <td>{{ $producto->descuento }}%</td>
                                <td>{{ $producto->incremento }}%</td>
                                <td>{{ $producto->marca }}</td>
                                <td>{{ $producto->piezas_por_paquete }}</td>
                                <td>{{ $producto->piezas_por_caja }}</td>
                                <td>{{ $producto->ubicacion->nombre ?? 'Sin ubicación' }}</td>
                                <td>{{ $producto->posicion}}</td>
                                <td>
                                    @if ($producto->docena == 1)
                                        <span class="badge badge-success" style="font-size: 1rem;">Sí</span>
                                    @else
                                        <span class="badge badge-danger" style="font-size: 1rem;">No</span>
                                    @endif
                                </td>
                                
                                <td>{{ $producto->cantidad }} Unidades</td>
                                <td>
                                    <span class="badge {{ $producto->estado === 'activo' ? 'badge-success' : 'badge-secondary' }}">
                                        {{ ucfirst($producto->estado) }}
                                    </span>
                                </td>
                              
                                @if(auth()->user()->hasRole('Super administrador'))
                                <td>
                                    <!-- Botón de editar -->
                                    <a href="{{ route('mercancia.edit', $producto) }}" class="btn btn-warning btn-sm">✏️ Editar</a>
                                
                                    <!-- Formulario para cambiar estado -->
                                    <form action="{{ route('mercancia.cambiarEstado', $producto) }}" method="POST" style="display:inline;">
                                        @csrf
                                        <button type="submit" class="btn btn-success btn-sm">🔄 Cambiar estado</button>
                                    </form>
                                
                                    <!-- Dropdown con enlaces directos -->
                                    <div class="dropdown d-inline-block">
                                        <button class="btn btn-info btn-sm dropdown-toggle" type="button" id="dropdownMenuButton{{ $producto->id }}" data-bs-toggle="dropdown" aria-expanded="false">
                                            🖨️ Imprimir Sticker
                                        </button>
                                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton{{ $producto->id }}">
                                            <li>
                                                <a class="dropdown-item" href="{{ route('mercancia.generarSticker', $producto->id) }}" target="_blank">Sticker PUF 5x5</a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="{{ route('mercancia.generarStickerPPN', $producto->id) }}" target="_blank">Sticker PPN 5x5</a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="{{ route('mercancia.generarStickerPPNGrande', $producto->id) }}" target="_blank">Sticker PPN 10x15</a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="{{ route('mercancia.generarStickerPUFGrande', $producto->id) }}" target="_blank">Sticker PUF 10x15</a>
                                            </li>
                                        </ul>
                                    </div>
                                </td>
                                
                                
                                
                                @endif
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                <div class="d-flex justify-content-center">
                    {{ $productos->links() }}
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Modal para mostrar la imagen ampliada -->
<div class="modal fade" id="imageModal" tabindex="-1" role="dialog" aria-labelledby="imageModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="imageModalLabel">Vista previa de la imagen</h5>
            </div>
            <div class="modal-body text-center">
                <img id="modalImage" src="" class="img-fluid" alt="Imagen del producto" style="max-height: 500px;">
            </div>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<script>
$(document).ready(function() {
    $('.img-thumbnail').on('click', function() {
        var imageUrl = $(this).attr('src'); 
        $('#modalImage').attr('src', imageUrl); 
        $('#imageModal').modal('show'); 
    });

    $('#imageModal').on('hidden.bs.modal', function () {
        $('#modalImage').attr('src', ''); 
    });
});
</script>
<script>
    $(document).ready(function() {
        // Inicializar Select2
        $('.select-sticker').select2({
            minimumResultsForSearch: Infinity, // Ocultar el cuadro de búsqueda
            width: '200px', // Ajustar ancho
            placeholder: "🖨️ Imprimir Sticker",
            allowClear: true // Permitir limpiar selección
        });
    });
</script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>

<style>

.modal-backdrop {
    background-color: rgba(0, 0, 0, 0.5); 
}
/* Estilización del botón dropdown */
.dropdown-toggle {
    border-radius: 5px;
    background-color: #17a2b8;
    color: white;
    font-weight: bold;
    padding: 6px 12px;
}

.dropdown-toggle:hover {
    background-color: #138496;
}

.dropdown-menu {
    border-radius: 8px;
    padding: 0;
    box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
}

.dropdown-item {
    padding: 10px 15px;
    font-size: 14px;
}

.dropdown-item:hover {
    background-color: #f8f9fa;
    color: #17a2b8;
}


</style>
@endsection
