@extends('layouts.app')

@section('content')
<section class="section">
    <div class="section-header">
        <h3 class="page__heading">Agregar Producto</h3>
    </div>

    <!-- Mensaje de error -->
    @if(session('error'))
        <div class="alert alert-danger" role="alert">
            {{ session('error') }}
        </div>
    @endif

    <!-- Formulario -->
    <form action="{{ route('mercancia.store') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="row">
            <!-- Columna Izquierda -->
            <div class="col-md-6">
                <div class="form-group">
                    <label for="nombre">Nombre del producto:</label>
                    <input type="text" name="nombre" class="form-control" value="{{ old('nombre') }}" required>
                    @error('nombre')<span class="text-danger">{{ $message }}</span>@enderror
                </div>
                <div class="form-group">
                    <label for="codigo1">Código 1:</label>
                    <input type="text" name="codigo1" class="form-control" value="{{ old('codigo1') }}" required>
                    @error('codigo1')<span class="text-danger">{{ $message }}</span>@enderror
                </div>
                <div class="form-group">
                    <label for="codigo2">Código 2:</label>
                    <input type="text" name="codigo2" class="form-control" value="{{ old('codigo2') }}">
                    @error('codigo2')<span class="text-danger">{{ $message }}</span>@enderror
                </div>
                <div class="form-group">
                    <label for="descripcion">Descripción:</label>
                    <textarea name="descripcion" class="form-control" rows="3" required>{{ old('descripcion') }}</textarea>
                    @error('descripcion')<span class="text-danger">{{ $message }}</span>@enderror
                </div>
                <div class="form-group">
                    <label for="precio_unidad_facturado">Precio Unidad Facturado (PUF):</label>
                    <input type="number" name="precio_unidad_facturado" step="0.01" class="form-control" value="{{ old('precio_unidad_facturado') }}" required>
                    @error('precio_unidad_facturado')<span class="text-danger">{{ $message }}</span>@enderror
                </div>
                <div class="form-group">
                    <label for="precio_docena_facturado">Precio Docena Facturado (PDF):</label>
                    <input type="number" name="precio_docena_facturado" step="0.01" class="form-control" value="{{ old('precio_docena_facturado') }}">
                    @error('precio_docena_facturado')<span class="text-danger">{{ $message }}</span>@enderror
                </div>
                <div class="form-group">
                    <label for="precio_paquete_facturado">Precio Paquete Facturado (PPF):</label>
                    <input type="number" name="precio_paquete_facturado" step="0.01" class="form-control" value="{{ old('precio_paquete_facturado') }}">
                    @error('precio_paquete_facturado')<span class="text-danger">{{ $message }}</span>@enderror
                </div>
            </div>

            <!-- Columna Derecha -->
            <div class="col-md-6">
                <div class="form-group">
                    <label for="precio_paquete_normal">Precio Paquete Normal (PPN):</label>
                    <input type="number" name="precio_paquete_normal" step="0.01" class="form-control" value="{{ old('precio_paquete_normal') }}">
                    @error('precio_paquete_normal')<span class="text-danger">{{ $message }}</span>@enderror
                </div>
                <div class="form-group">
                    <label for="precio_docena_normal">Precio Docena Normal (PDN):</label>
                    <input type="number" name="precio_docena_normal" step="0.01" class="form-control" value="{{ old('precio_docena_normal') }}">
                    @error('precio_docena_normal')<span class="text-danger">{{ $message }}</span>@enderror
                </div>
                <div class="form-group">
                    <label for="precio_docena_caja">Precio Docena por Caja (PDC):</label>
                    <input type="number" name="precio_docena_caja" step="0.01" class="form-control" value="{{ old('precio_docena_caja') }}">
                    @error('precio_docena_caja')<span class="text-danger">{{ $message }}</span>@enderror
                </div>
                <div class="form-group">
                    <label for="marca">Marca:</label>
                    <input type="text" name="marca" class="form-control" value="{{ old('marca') }}" required>
                    @error('marca')<span class="text-danger">{{ $message }}</span>@enderror
                </div>
                <div class="form-group">
                    <label for="foto">Foto del producto:</label>
                    <input type="file" name="foto" class="form-control-file">
                    @error('foto')<span class="text-danger">{{ $message }}</span>@enderror
                </div>
                <div class="form-group">
                    <label for="ubicacion_id">Ubicación:</label>
                    <select name="ubicacion_id" class="form-control select2" required>
                        <option value="">Seleccione una ubicación</option>
                        @foreach($ubicaciones as $ubicacion)
                            <option value="{{ $ubicacion->id }}" {{ old('ubicacion_id') == $ubicacion->id ? 'selected' : '' }}>
                                {{ $ubicacion->nombre }}
                            </option>
                        @endforeach
                    </select>
                    @error('ubicacion_id')<span class="text-danger">{{ $message }}</span>@enderror
                </div>
                <div class="form-group">
                    <label for="cantidad">Cantidad:</label>
                    <input type="number" name="cantidad" class="form-control" value="{{ old('cantidad') }}" required>
                    @error('cantidad')<span class="text-danger">{{ $message }}</span>@enderror
                </div>
                <div class="form-group">
                    <label for="piezas_por_paquete">Piezas por Paquete:</label>
                    <input type="number" name="piezas_por_paquete" class="form-control" value="{{ old('piezas_por_paquete') }}" required>
                    @error('piezas_por_paquete')<span class="text-danger">{{ $message }}</span>@enderror
                </div>
                <div class="form-group">
                    <label for="piezas_por_caja">Piezas por Caja:</label>
                    <input type="number" name="piezas_por_caja" class="form-control" value="{{ old('piezas_por_caja') }}" required>
                    @error('piezas_por_caja')<span class="text-danger">{{ $message }}</span>@enderror
                </div>
                <div class="form-group">
                    <label for="posicion">Posición en el Depósito:</label>
                    <input type="text" name="posicion" class="form-control" value="{{ old('posicion', $producto->posicion ?? '') }}">
                </div>
                <div class="form-group">
                    <label>¿Este producto es válido para su venta en cuarta, media docena y docena?</label>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="docena" id="docena_si" value="1" required>
                        <label class="form-check-label" for="docena_si">Sí</label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="radio" name="docena" id="docena_no" value="0" required>
                        <label class="form-check-label" for="docena_no">No</label>
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="descuento">Descuento (%):</label>
                    <input type="number" name="descuento" step="0.01" class="form-control" value="{{ old('descuento', 0) }}">
                    @error('descuento')<span class="text-danger">{{ $message }}</span>@enderror
                </div>
                <div class="form-group">
                    <label for="incremento">Incremento (%):</label>
                    <input type="number" name="incremento" step="0.01" class="form-control" value="{{ old('incremento', 0) }}">
                    @error('incremento')<span class="text-danger">{{ $message }}</span>@enderror
                </div>
                <input type="hidden" name="estado" value="activo">
            </div>
        </div>
 
        <button type="submit" class="btn btn-primary">Guardar Producto</button>
    </form>
</section>

<!-- Scripts -->
<script>
    $(document).ready(function() {
        $('.select2').select2();
    });
</script>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0/css/select2.min.css" rel="stylesheet" />
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0/js/select2.min.js"></script>
@endsection
