@extends('layouts.app')

@section('content')
<div class="container mt-4">
    <div class="card shadow-sm border-0 rounded">
        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
            <h2 class="mb-0">Gestión de Empleados</h2>
            <a href="{{ route('empleados.create') }}" class="btn btn-light">
                <i class="fas fa-plus-circle"></i> Agregar Empleado
            </a>
        </div>
        <div class="card-body">
       
            @if(session('success'))
            <div class="alert alert-success mt-3">
                {{ session('success') }}
            </div>
        @endif
        @if(session('error'))
            <div class="alert alert-danger mt-3">
                {{ session('error') }}
            </div>
        @endif
        @if(isset($error))
            <div class="alert alert-danger mt-3">
                {{ $error }}
            </div>
        @endif
            <!-- Filtros y Buscador -->
            <form method="GET" action="{{ route('empleados.index') }}" class="mb-4">
                <div class="row g-3">
                    <div class="col-lg-4">
                        <input type="text" name="search" class="form-control" placeholder="Buscar por carnet, nombre o apellidos" value="{{ request('search') }}">
                    </div>
                    <div class="col-lg-4">
                        <select name="sucursal_id" class="form-select">
                            <option value="">Filtrar por sucursal</option>
                            @foreach($ubicaciones as $ubicacion)
                                <option value="{{ $ubicacion->id }}" {{ request('sucursal_id') == $ubicacion->id ? 'selected' : '' }}>
                                    {{ $ubicacion->nombre }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-lg-4 d-flex gap-2">
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-filter"></i> Filtrar
                        </button>
                        <a href="{{ route('empleados.index') }}" class="btn btn-secondary w-100">
                            <i class="fas fa-sync"></i> Limpiar
                        </a>
                    </div>
                </div>
            </form>

            <!-- Tabla de empleados -->
            <div class="table-responsive">
                <table class="table table-hover table-bordered align-middle text-center">
                    <thead class="bg-light">
                        <tr>
                       
                            <th>Nombre</th>
                            <th>Apellidos</th>
                            <th>Carnet</th>
                            <th>Fecha de nacimiento</th>
                            <th>Telefono</th>
                            <th>Correo</th>
                            <th>Sucursal</th>
                            <th>Estado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($empleados as $empleado)
                            <tr>
                         
                                <td>{{ $empleado->nombre }}</td>
                                <td>{{ $empleado->apellidos }}</td>
                                <td>{{ $empleado->carnet }}</td>
                                <td>{{ \Carbon\Carbon::parse($empleado->fecha_nacimiento)->format('d/m/Y') }}</td>


                                <td>{{ $empleado->telefono }}</td>
                                <td>{{ $empleado->correo }}</td>
                                <td>{{ $empleado->sucursal->nombre ?? 'Sin asignar' }}</td>
                                <td>
                                    <span class="badge {{ $empleado->estado ? 'bg-success' : 'bg-danger' }}">
                                        {{ $empleado->estado ? 'Activo' : 'Inactivo' }}
                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group" role="group" aria-label="Acciones">
                                        <!-- Botón Editar -->
                                        <a href="{{ route('empleados.edit', $empleado->id) }}" class="btn btn-warning btn-sm" title="Editar Empleado">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                    
                                        <!-- Botón Activar/Desactivar -->
                                        <form action="{{ route('empleados.destroy', $empleado->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm" title="{{ $empleado->estado ? 'Desactivar Empleado' : 'Activar Empleado' }}">
                                                <i class="fas fa-user-slash"></i>
                                            </button>
                                        </form>
                                    
                                        <!-- Botón Generar Usuario (Sólo si el empleado está activo) -->
                                        @if($empleado->estado)
                                            <form action="{{ route('empleados.generateUserForm', $empleado->id) }}" method="get">
                                                @csrf
                                                <button type="submit" class="btn btn-success btn-sm" title="Generar Usuario">
                                                    <i class="fas fa-user-cog"></i>
                                                </button>
                                            </form>
                                        @endif
                                    </div>
                                </td>
                                
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center text-muted">No se encontraron empleados.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Paginación -->
            <div class="d-flex justify-content-center mt-4">
                {{ $empleados->links() }}
            </div>
        </div>
    </div>
</div>
@endsection
