@extends('layouts.app')

@section('content')
<section class="section">
    <div class="section-header">
        <h3 class="page__heading">➕ Registrar Nueva Compra</h3>
    </div>

    <form action="{{ route('compras.store') }}" method="POST">
        @csrf
        <div class="row">
            <!-- Selección del Producto -->
            <div class="col-md-6">
                <label for="producto_id">📦 Producto:</label>
                <select name="producto_id" id="producto_id" class="form-control select2" required>
                    <option value="">Seleccione un producto</option>
                    @foreach($productos as $producto)
                    <option value="{{ $producto->id }}" 
                        data-nombre="{{ $producto->nombre }}"
                        data-codigo1="{{ $producto->codigo1 }}"
                        data-codigo2="{{ $producto->codigo2 }}"
                        data-cantidad="{{ $producto->cantidad }}"
                        data-descripcion="{{ $producto->descripcion }}"
                        data-piezas_por_caja="{{ $producto->piezas_por_caja }}"
                        data-piezas_por_paquete="{{ $producto->piezas_por_paquete }}">
                        {{ $producto->nombre }} (Código: {{ $producto->codigo1 ?? 'N/A' }})(Sucursal: {{ $producto->ubicacion->nombre ?? 'N/A' }})
                        (Cantidad: {{ $producto->cantidad ?? 'N/A' }})
                    </option>
                @endforeach
                
                </select>
            </div>

            <!-- Selección de Ubicación -->
            <div class="col-md-6">
                <label for="ubicacion_id">📍 Ubicación:</label>
                <select name="ubicacion_id" class="form-control select2" required>
                    <option value="">Seleccione una ubicación</option>
                    @foreach($ubicaciones as $ubicacion)
                        <option value="{{ $ubicacion->id }}">{{ $ubicacion->nombre }}</option>
                    @endforeach
                </select>
            </div>

            <!-- Detalles del Producto -->
          <!-- Detalles del Producto -->
<div class="col-md-6 mt-3">
    <label>📝 Detalles del Producto:</label>
    <ul class="list-group">
        <li class="list-group-item"><strong>Nombre:</strong> <span id="producto_nombre">N/A</span></li>
        <li class="list-group-item"><strong>Código 1:</strong> <span id="producto_codigo1">N/A</span></li>
        <li class="list-group-item"><strong>Código 2:</strong> <span id="producto_codigo2">N/A</span></li>
        <li class="list-group-item"><strong>Cantidad Disponible:</strong> <span id="producto_cantidad">N/A</span></li>
        <li class="list-group-item"><strong>Descripción:</strong> <span id="producto_descripcion">N/A</span></li>
        <li class="list-group-item"><strong>Piezas por caja:</strong> <span id="producto_piezas_por_caja">N/A</span></li>
        <li class="list-group-item"><strong>Piezas por paquete:</strong> <span id="producto_piezas_por_paquete">N/A</span></li>
    </ul>
</div>


            <!-- Cantidad y Costo -->
            <div class="col-md-3 mt-3">
                <label for="cantidad">📊 Cantidad:</label>
                <input type="number" name="cantidad" id="cantidad" class="form-control" required min="1">
            </div>
            <div class="col-md-3 mt-3">
                <label for="costo_total">💰 Costo Total:</label>
                <input type="number" name="costo_total" step="0.01" class="form-control" required>
            </div>

            <!-- Observación -->
            <div class="col-md-12 mt-3">
                <label for="observacion">📝 Observación:</label>
                <textarea name="observacion" class="form-control" rows="2"></textarea>
            </div>
        </div>

        <!-- Botones -->
        <div class="mt-4">
            <button type="submit" class="btn btn-success">💾 Guardar</button>
            <a href="{{ route('compras.index') }}" class="btn btn-secondary">Cancelar</a>
        </div>
    </form>
</section>

<!-- Scripts -->
@section('scripts')
<script>
 $(document).ready(function() {
    // Inicializar Select2
    $('.select2').select2();

    // Actualizar detalles del producto al seleccionar uno
    $('#producto_id').on('change', function() {
        const selectedOption = $(this).find('option:selected');
        $('#producto_nombre').text(selectedOption.data('nombre') || 'N/A');
        $('#producto_codigo1').text(selectedOption.data('codigo1') || 'N/A');
        $('#producto_codigo2').text(selectedOption.data('codigo2') || 'N/A');
        $('#producto_cantidad').text(selectedOption.data('cantidad') || 'N/A');
        $('#producto_descripcion').text(selectedOption.data('descripcion') || 'N/A');
        $('#producto_piezas_por_caja').text(selectedOption.data('piezas_por_caja') || 'N/A');
        $('#producto_piezas_por_paquete').text(selectedOption.data('piezas_por_paquete') || 'N/A');
    });
});


</script>
@endsection
@endsection
