@extends('layouts.app')

@section('content')
<section class="section">
    <!-- Encabezado -->
    <div class="section-header d-flex justify-content-between align-items-center">
        <h3 class="page__heading"> Gestión de Clientes</h3>
        <a href="{{ route('clientes.create') }}" class="btn btn-primary shadow">➕ Registrar Cliente</a>
    </div>
    {{-- Mensajes de éxito --}}
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    {{-- Barra de búsqueda --}}
    <form method="GET" action="{{ route('clientes.index') }}" class="mb-4">
        <div class="input-group">
            <input type="text" name="buscar" class="form-control" placeholder="Buscar por nombre, apellidos, carnet o teléfono" value="{{ request('buscar') }}">
            <button type="submit" class="btn btn-primary">Buscar</button>
        </div>
    </form>
    <a href="{{ route('clientes.index') }}" class="btn btn-primary shadow">➕ Ver todos </a>
    {{-- Tabla de clientes --}}
    <table class="table table-striped">
        <thead>
            <tr>
                <th>Nombre</th>
                <th>Apellidos</th>
                <th>Carnet / NIT</th>
                <th>Teléfono</th>
                <th>Observaciones</th>
                <th>Estado</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($clientes as $cliente)
                <tr>
                    <td>{{ $cliente->nombre }}</td>
                    <td>{{ $cliente->apellidos }}</td>
                    <td>{{ $cliente->carnet }}</td>
                    <td>{{ $cliente->telefono }}</td>
                    <td>{{ $cliente->observacion }}</td>
                    <td>
                        <span class="badge {{ $cliente->estado ? 'bg-success' : 'bg-danger' }}">
                            {{ $cliente->estado ? 'Activo' : 'Inactivo' }}
                        </span>
                    </td>
                    <td>
                        <a href="{{ route('clientes.edit', $cliente->id) }}" class="btn btn-warning btn-sm">Editar</a>
                        <form action="{{ route('clientes.destroy', $cliente->id) }}" method="POST" style="display:inline-block;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger btn-sm">
                                {{ $cliente->estado ? 'Desactivar' : 'Activar' }}
                            </button>
                        </form>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" class="text-center">No se encontraron clientes.</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    {{-- Paginación --}}
    {{ $clientes->links() }}
</div>
@endsection
