<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Venta extends Model
{
    use HasFactory;
    protected $table = 'ventas_nueva';

    protected $fillable = [
        'user_id',
     
        'ubicacion_id',
        'codigo',
        'estado',
        'precio_total',
        'fecha',
        'hora',
        'usuario_aprobador_id', 
          'usuario_rechazador_id',
          'cliente_id', // Nuevo campo
          'observacion', // Nuevo campo
        
    ];
    protected static function boot()
    {
        parent::boot();
    
        static::creating(function ($venta) {
            // Generar el código de la venta
            $venta->codigo = self::generarCodigoUnico();
        });
    }
    public function setObservacionAttribute($value)
{
    $this->attributes['observacion'] = $value ?: 'Ninguna';
}

    public static function generarCodigoUnico()
    {
        do {
            // Generar código único: Prefijo + Fecha + Número aleatorio
            $codigo = 'VTA-' . now()->format('Ymd') . '-' . rand(1000, 9999);
        } while (self::where('codigo', $codigo)->exists());
    
        return $codigo;
    }
    public function usuario()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function productosVendidos()
    {
        return $this->hasMany(ProductoVendido::class, 'venta_id');
    }
    
    public function ubicacion()
    {
        return $this->belongsTo(Ubicacion::class);
    }
    public function getPrecioConCambioAttribute()
    {
        $tipoCambio = session('tipo_cambio', 1); // Usar 1 como valor predeterminado
        return $this->precio * $tipoCambio;
    }
    public function usuarioAprobador()
    {
        return $this->belongsTo(User::class, 'usuario_aprobador_id');
    }
    public function usuarioRechazador()
{
    return $this->belongsTo(User::class, 'usuario_rechazador_id');
}
public function cliente()
{
    return $this->belongsTo(Cliente::class);
}


    
}
